﻿'*******************************************************************************
'このプログラムは、計測器に接続してコマンドの送受信を行います。
'コマンドの欄に送信したいコマンドを入力し、[送受信]ボタンを押すと送信されます。
'応答があるコマンド（?が含まれるコマンド）の場合は、テキストボックスに応答が表示されます。
'
'(株)コンテックが公開しているGPIBのサンプルコードを参考にしています。
'サンプルコードのGpibvb.vbおよびSubFunc.vbをプロジェクトに追加しています。
'追加したGpibvb.vbにGpibInput関数を改造したGpibInputHioki関数を追加しています。
'
'動作確認環境
'   Microsoft Visual Studio Professional 2017
'   Microsoft.NET Framework 4.7
'*******************************************************************************

Public Class Form1

    Private comm As GPIB_CONTEC

    'フォームが開かれたときの処理
    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles Me.Load
        'ボタンとテキストボックスの有効/無効の処理
        Button1.Enabled = True
        Button2.Enabled = False
        Button3.Enabled = False
        TextBox1.Enabled = False
        TextBox2.Enabled = True
        TextBox3.Enabled = False
        TextBox4.Enabled = False
        TextBox5.ReadOnly = True
    End Sub

    '「接続」ボタンを押したときの処理
    Private Sub Button1_Click(sender As System.Object, e As EventArgs) Handles Button1.Click
        'GPIBオブジェクト生成
        comm = New GPIB_CONTEC()

        '接続
        If comm.OpenInterface(TextBox2.Text) = False Then
            Exit Sub
        End If

        'マイアドレスの表示
        TextBox1.Text = comm.MyAddress.ToString()

        'ボタンとテキストボックスの有効/無効の処理
        Button1.Enabled = False
        Button2.Enabled = True
        Button3.Enabled = True
        TextBox2.Enabled = False
        TextBox3.Enabled = True
        TextBox4.Enabled = True
    End Sub

    '「切断」ボタンを押したときの処理
    Private Sub Button2_Click(sender As System.Object, e As EventArgs) Handles Button2.Click
        '切断
        comm.CloseInterface()

        'ボタンとテキストボックスの有効/無効の処理
        Button1.Enabled = True
        Button2.Enabled = False
        Button3.Enabled = False
        TextBox2.Enabled = True
        TextBox3.Enabled = False
        TextBox4.Enabled = False
    End Sub

    '「送受信」ボタンを押したときの処理
    Private Sub Button3_Click(sender As System.Object, e As EventArgs) Handles Button3.Click
        Button3.Enabled = False

        TextBox5.AppendText("<< " + TextBox3.Text + vbCrLf)                             '送信データログ出力
        comm.SendQueryMsg(TextBox3.Text, CLng(TextBox4.Text) * 1000)                    '送受信
        If InStr(TextBox3.Text, "?") <> 0 Then                                          'コマンドに?が含まれる場合
            TextBox5.AppendText(">> " + comm.MsgBuf + vbCrLf)                           '受信データログ出力
        End If

        Button3.Enabled = True
    End Sub

    '「クリア」ボタンを押したときの処理
    Private Sub Button4_Click(sender As System.Object, e As EventArgs) Handles Button4.Click
        'テキストボックスの消去
        TextBox5.Clear()
    End Sub

End Class

